/*
 * Decompiled with CFR 0.152.
 */
package tfar.overpoweredarmorbar.overlay;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import tfar.overpoweredarmorbar.Configs;
import tfar.overpoweredarmorbar.overlay.ArmorBar;
import tfar.overpoweredarmorbar.overlay.ArmorIcon;
import tfar.overpoweredarmorbar.overlay.ArmorIconColor;

public class OverlayEventHandler {
    private static final int UNKNOWN_ARMOR_VALUE = -1;
    private int previousArmorValue = -1;
    private static final int ARMOR_ICON_SIZE = 9;
    private static final int ARMOR_SECOND_HALF_ICON_SIZE = 4;
    private Minecraft mc = Minecraft.func_71410_x();
    private ArmorIcon[] armorIcons;

    public static void drawTexturedModalRect(MatrixStack stack, int x, int y, int textureX, int textureY, int width, int height) {
        Minecraft.func_71410_x().field_71456_v.func_238474_b_(stack, x, y, textureX, textureY, width, height);
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onRenderGameOverlayEventPre(RenderGameOverlayEvent event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ARMOR) {
            return;
        }
        int scaledWidth = this.mc.func_228018_at_().func_198107_o();
        int scaledHeight = this.mc.func_228018_at_().func_198087_p();
        this.renderArmorBar(event.getMatrixStack(), scaledWidth, scaledHeight);
        event.setCanceled(true);
    }

    private int calculateArmorValue() {
        int currentArmorValue = this.mc.field_71439_g.func_70658_aO();
        return currentArmorValue;
    }

    public void renderArmorBar(MatrixStack stack, int screenWidth, int screenHeight) {
        int currentArmorValue = this.calculateArmorValue();
        int xStart = screenWidth / 2 - 91;
        int yPosition = screenHeight - ForgeIngameGui.left_height;
        if (currentArmorValue != this.previousArmorValue) {
            this.armorIcons = ArmorBar.calculateArmorIcons(currentArmorValue);
            this.previousArmorValue = currentArmorValue;
        }
        RenderSystem.pushMatrix();
        int armorIconCounter = 0;
        for (ArmorIcon icon : this.armorIcons) {
            int xPosition = xStart + armorIconCounter * 8;
            switch (icon.armorIconType) {
                case NONE: {
                    ArmorIconColor color = icon.primaryArmorIconColor;
                    OverlayEventHandler.color4f(color.Red, color.Green, color.Blue, color.Alpha);
                    if (currentArmorValue > 20) {
                        OverlayEventHandler.drawTexturedModalRect(stack, xPosition, yPosition, 34, 9, 9, 9);
                        break;
                    }
                    if (!((Boolean)Configs.ClientConfig.showEmptyArmorIcons.get()).booleanValue() || !((Boolean)Configs.ClientConfig.alwaysShowArmorBar.get()).booleanValue() && currentArmorValue <= 0) break;
                    OverlayEventHandler.drawTexturedModalRect(stack, xPosition, yPosition, 16, 9, 9, 9);
                    break;
                }
                case HALF: {
                    ArmorIconColor firstHalfColor = icon.primaryArmorIconColor;
                    ArmorIconColor secondHalfColor = icon.secondaryArmorIconColor;
                    OverlayEventHandler.color4f(firstHalfColor.Red, firstHalfColor.Green, firstHalfColor.Blue, firstHalfColor.Alpha);
                    OverlayEventHandler.drawTexturedModalRect(stack, xPosition, yPosition, 25, 9, 5, 9);
                    OverlayEventHandler.color4f(secondHalfColor.Red, secondHalfColor.Green, secondHalfColor.Blue, secondHalfColor.Alpha);
                    if (currentArmorValue > 20) {
                        OverlayEventHandler.drawTexturedModalRect(stack, xPosition + 5, yPosition, 39, 9, 4, 9);
                        break;
                    }
                    OverlayEventHandler.drawTexturedModalRect(stack, xPosition + 5, yPosition, 30, 9, 4, 9);
                    break;
                }
                case FULL: {
                    ArmorIconColor fullColor = icon.primaryArmorIconColor;
                    OverlayEventHandler.color4f(fullColor.Red, fullColor.Green, fullColor.Blue, fullColor.Alpha);
                    OverlayEventHandler.drawTexturedModalRect(stack, xPosition, yPosition, 34, 9, 9, 9);
                    break;
                }
            }
            ++armorIconCounter;
        }
        OverlayEventHandler.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.func_227627_O_();
    }

    private static void color4f(float r, float g, float b, float a) {
        RenderSystem.color4f((float)r, (float)g, (float)b, (float)a);
    }
}

